<!DOCTYPE html>
<?php require 'config.php'; ?>
<html lang="et">

<head>
  <!-- Required Meta Tags Always Come First -->
  <meta charset="utf-8">
  <meta name="robots" content="index, follow">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description"
    content="Normani mälestusleht - koht, kus jagada mälestusi ja meenutusi meie kalli Normani kohta.">

  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Normani mälestusleht">
  <meta name="twitter:description"
    content="Normani mälestusleht - koht, kus jagada mälestusi ja meenutusi meie kalli Normani kohta.">
  <meta name="twitter:image" content="./assets/failid/pildid/norman.jpg">

  <meta property="og:url" content="">
  <meta property="og:locale" content="et_EE">
  <meta property="og:type" content="website">
  <meta property="og:site_name" content="Normani mälestusleht">
  <meta property="og:title" content="Normani mälestusleht">
  <meta property="og:description"
    content="Normani mälestusleht - koht, kus jagada mälestusi ja meenutusi meie kalli Normani kohta.">
  <meta property="og:image" content="./assets/failid/pildid/norman.jpg">

  <!-- Title -->
  <title>Normani mälestusleht</title>

  <!-- Favicon -->
  <link rel="shortcut icon" href="./favicon.ico">

  <!-- Font -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">



  <!-- CSS Preline -->
  <link href="./assets/css/main.min.css" rel="stylesheet">

  <style>
    /* Pisipiltide stiil mobiilivaates */
    @media (max-width: 768px) {
      .hs-carousel-pagination-item {
        width: 60px;
        /* Määratud laiuse suurus */
        height: 40px;
        /* Määratud kõrguse suurus */
        overflow: hidden;
      }

      .hs-carousel-pagination-item img {
        object-fit: cover;
        /* Säilitab pildi proportsioonid */
        width: 100%;
        /* Täidab täielikult elemendi laiuse */
        height: 100%;
        /* Täidab täielikult elemendi kõrguse */
      }
    }

    /* Üldine stiil mobiilivaates */
    @media screen and (max-width: 768px) {

      input,
      select,
      textarea {
        font-size: 16px !important;
      }

      /* Takista horisontaalset kerimist */
      html,
      body {
        overflow-x: hidden;
        position: relative;
        width: 100%;
      }

      /* Kindlusta, et vorm püsib ekraani piirides */
      form {
        max-width: 100vw;
        width: 100%;
      }

      /* Kindlusta, et sisendväljad püsivad vormi piirides */
      input,
      textarea,
      select {
        max-width: 100%;
        width: 100%;
        box-sizing: border-box;
        caret-color: white;
        /* Kursori värvi muutmiseks */
      }
    }
  </style>

</head>

<body>

  <!-- ========== MAIN CONTENT ========== -->
  <main id="content">
    <!-- Hero Section -->
    <div class="bg-neutral-900 pt-10">
      <div class="max-w-5xl mx-auto px-4 xl:px-0 py-6 lg:py-2">
        <div class="flex flex-col items-center">
          <!-- //LINK - Pilt -->
          <img class="rounded-xl w-full max-w-[280px] sm:max-w-lg mb-6 lg:mb-10" src="./assets/failid/pildid/norman.jpg"
            alt="Norman Ööveli pilt">
          <div class="text-center">
            <h1 class="font-semibold text-white text-5xl md:text-6xl">
              <!-- //LINK - Pealkiri -->
              <span class="text-neutral-400 text-3xl md:text-3xl block mb-2">In Memoriam</span>
              Norman Öövel
              <span class="text-neutral-400 text-xl md:text-2xl block mt-2">1990 - 2025</span>
            </h1>
            <div class="max-w-xl">
              <p class="mt-5 text-neutral-400 text-lg">
                Siin lehel saad lugeda südamlikke lugusid ja meenutusi meile kallist Normanist. Iga siia lisatud tagasivaade, järelehüüe või pilt aitab meil pühitseda Normani elu ja hoida mälestust temast meie südameis. Postitamiseks mine läbi eelnevate meenutuste.
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End Hero Section -->

    <!-- //LINK - Galerii -->
    <div class="bg-neutral-900">
      <div class="max-w-xl px-40 xl:px-0 py-5 lg:pb-20 mx-auto">
        <div data-hs-carousel='{
          "loadingClasses": "opacity-0", 
          "isInfinite": true,
          "isTouch": true,
          "autoplay": false
        }' class="relative">
          <div class="hs-carousel relative overflow-hidden w-full min-h-96 bg-neutral-900 rounded-lg">
            <div
              class="hs-carousel-body absolute top-0 bottom-0 start-0 flex flex-nowrap transition-transform duration-700 opacity-0">
              <div class="hs-carousel-slide">
                <div class="flex justify-center h-full bg-gray-100 p-6 dark:bg-neutral-900">
                  <img src="./assets/failid/pildid/1.jpg" class="object-cover w-full h-full rounded-lg"
                    alt="Norman Öövel">
                </div>
              </div>
              <div class="hs-carousel-slide">
                <div class="flex justify-center h-full bg-gray-200 p-6 dark:bg-neutral-800">
                  <img src="./assets/failid/pildid/2.jpg" class="object-cover w-full h-full rounded-lg"
                    alt="Norman Öövel">
                </div>
              </div>
              <div class="hs-carousel-slide">
                <div class="flex justify-center h-full bg-gray-300 p-6 dark:bg-neutral-700">
                  <img src="./assets/failid/pildid/3.jpg" class="object-cover w-full h-full rounded-lg"
                    alt="Norman Öövel">
                </div>
              </div>
              <div class="hs-carousel-slide">
                <div class="flex justify-center h-full bg-gray-100 p-6 dark:bg-neutral-900">
                  <img src="./assets/failid/pildid/4.jpg" class="object-cover w-full h-full rounded-lg"
                    alt="Norman Öövel">
                </div>
              </div>
              <div class="hs-carousel-slide">
                <div class="flex justify-center h-full bg-gray-200 p-6 dark:bg-neutral-800">
                  <img src="./assets/failid/pildid/5.jpg" class="object-cover w-full h-full rounded-lg"
                    alt="Norman Öövel">
                </div>
              </div>
            </div>

            <button type="button"
              class="hs-carousel-prev hs-carousel-disabled:opacity-50 hs-carousel-disabled:pointer-events-none absolute inset-y-0 start-0 inline-flex justify-center items-center w-[120px] h-full text-gray-800 hover:bg-gray-800/10 focus:outline-none focus:bg-gray-800/10 rounded-s-lg dark:text-white dark:hover:bg-white/10 dark:focus:bg-white/10">
              <span class="text-4xl" aria-hidden="true">
                <svg class="shrink-0 size-8" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                  viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                  stroke-linejoin="round">
                  <path d="m15 18-6-6 6-6"></path>
                </svg>
              </span>
              <span class="sr-only">Previous</span>
            </button>
            <button type="button"
              class="hs-carousel-next hs-carousel-disabled:opacity-50 hs-carousel-disabled:pointer-events-none absolute inset-y-0 end-0 inline-flex justify-center items-center w-[120px] h-full text-gray-800 hover:bg-gray-800/10 focus:outline-none focus:bg-gray-800/10 rounded-e-lg dark:text-white dark:hover:bg-white/10 dark:focus:bg-white/10">
              <span class="sr-only">Next</span>
              <span class="text-4xl" aria-hidden="true">
                <svg class="shrink-0 size-8" xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                  viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                  stroke-linejoin="round">
                  <path d="m9 18 6-6-6-6"></path>
                </svg>
              </span>
            </button>
          </div>

          <div class="hs-carousel-pagination mt-4">
            <div class="flex flex-row items-center justify-center gap-x-2">
              <div
                class="hs-carousel-pagination-item shrink-0 border rounded-md overflow-hidden cursor-pointer w-[75px] h-[50px] hs-carousel-active:border-blue-400">
                <div class="flex justify-center h-full bg-gray-100 p-2 dark:bg-neutral-900">
                  <img src="./assets/failid/pildid/1.jpg" class="object-cover w-full h-full rounded-sm"
                    alt="Norman Öövel">
                </div>
              </div>
              <div
                class="hs-carousel-pagination-item shrink-0 border rounded-md overflow-hidden cursor-pointer w-[75px] h-[50px] hs-carousel-active:border-blue-400">
                <div class="flex justify-center h-full bg-gray-200 p-2 dark:bg-neutral-800">
                  <img src="./assets/failid/pildid/2.jpg" class="object-cover w-full h-full rounded-sm"
                    alt="Norman Öövel">
                </div>
              </div>
              <div
                class="hs-carousel-pagination-item shrink-0 border rounded-md overflow-hidden cursor-pointer w-[75px] h-[50px] hs-carousel-active:border-blue-400">
                <div class="flex justify-center h-full bg-gray-300 p-2 dark:bg-neutral-700">
                  <img src="./assets/failid/pildid/3.jpg" class="object-cover w-full h-full rounded-sm"
                    alt="Norman Öövel">
                </div>
              </div>
              <div
                class="hs-carousel-pagination-item shrink-0 border rounded-md overflow-hidden cursor-pointer w-[75px] h-[50px] hs-carousel-active:border-blue-400">
                <div class="flex justify-center h-full bg-gray-100 p-2 dark:bg-neutral-900">
                  <img src="./assets/failid/pildid/4.jpg" class="object-cover w-full h-full rounded-sm"
                    alt="Norman Öövel">
                </div>
              </div>
              <div
                class="hs-carousel-pagination-item shrink-0 border rounded-md overflow-hidden cursor-pointer w-[75px] h-[50px] hs-carousel-active:border-blue-400">
                <div class="flex justify-center h-full bg-gray-200 p-2 dark:bg-neutral-800">
                  <img src="./assets/failid/pildid/5.jpg" class="object-cover w-full h-full rounded-sm"
                    alt="Norman Öövel">
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>



    <!-- Contact -->
    <div class="bg-neutral-900 pb-10">
      <div class="max-w-lg px-4 xl:px-0 py-1 lg:py-1 mx-auto">
          
                        <div id="memory-list" class="">
                <div class="max-w-3xl mb-4 lg:mb-3 text-center mx-auto">
                  <h2 class="text-white font-semibold text-3xl md:text-4xl md:leading-tight">Fotoalbum</h2>
                </div>
              </div>
              <div class="max-w-lg px-4 xl:px-0 py-1 lg:py-1 mx-auto">
                <div class="text-justify">
                  <p class="mt-3 text-neutral-400 text-lg text-justify">Pilte Normanist saab vaadata klõpsates <a href="https://photos.app.goo.gl/3Niof9xRLcCFxxyW8" target="_blank" class="text-blue-400 hover:text-blue-300 text-lg font-bold underline">albumi lingile SIIN</a>.</p>
                </div>
              </div>

        <!-- //LINK - Meenutused -->
        <div id="memory-list" class="mt-10">
          <div class="max-w-3xl mb-7 lg:mb-5 text-center mx-auto">
            <h2 class="text-white font-semibold text-3xl md:text-4xl md:leading-tight">Meenutused</h2>
          </div>
          <div class="space-y-4">
            <!-- Dynamically added memories will appear here -->
          </div>
        </div>

        <div class="space-y-4">
          <?php
          require 'config.php'; // Ensure the database is connected
          $memories = $db->query("SELECT * FROM memories ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

          foreach ($memories as $memory) {
            echo '<div class="bg-neutral-800 p-4 rounded-lg hover:bg-neutral-700/50 transition-colors shadow-md">';
            echo '<div class="flex justify-between items-start">';

            // Pealkiri vasakul
            echo '<div>';
            echo '<h5 class="text-white text-xl font-semibold mb-0">' . htmlspecialchars($memory['name']) . '</h5>';
            echo '<span class="text-neutral-500 text-md">' . htmlspecialchars($memory['connection']) . '</span>';
            echo '</div>';

            // Kuupäev paremal ülevel
            echo '<span class="text-neutral-500 text-sm">' . date('d.m.Y H:i', strtotime($memory['date_added'])) . '</span>';
            echo '</div>';

            // Mälestus
            echo '<div class="mt-2">';
            echo '<p class="text-neutral-400 text-sm leading-relaxed">' . nl2br(htmlspecialchars_decode($memory['memory'])) . '</p>';

            echo '</div>';

            // Pilt
            if (!empty($memory['filePath'])) {
              echo '<div class="mt-3">';
              echo '<img src="pildid/' . htmlspecialchars($memory['filePath']) . '" alt="Memory image" class="rounded-lg w-full max-w-2xl shadow-md hover:opacity-95 transition-opacity">';
              echo '</div>';
            }

            echo '</div>';
          }
          ?>
        </div>
        
                <!-- //LINK - Sinu meenutus -->
        <div class="max-w-3xl mb-7 lg:mb-5 text-center mx-auto pt-10">
          <h2 class="text-white font-semibold text-3xl md:text-4xl md:leading-tight">Sinu meenutus</h2>
          <p class="mt-1 text-neutral-400">Jaga oma mälestusi Normanist</p>
        </div>

        <!-- Grid -->
        <div class="grid grid-cols-1 gap-x-10 lg:gap-x-16 justify-items-center">
          <div class="border-b border-neutral-800 pb-10 mb-10 md:border-b-0 md:pb-0 md:mb-0">

            <!-- //SECTION - Form -->
            <form id="memory-form" action="/norman/upload.php" method="POST" enctype="multipart/form-data">

              <div class="space-y-4">
                <!-- //LINK - Nimi -->
                <div class="relative">
                  <input type="text" id="hs-tac-input-name" name="name"
                    class="peer p-4 block w-full bg-neutral-800 border-transparent rounded-lg text-sm text-white placeholder:text-transparent focus:outline-none focus:ring-0 focus:border-transparent disabled:opacity-50 disabled:pointer-events-none focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2 autofill:pt-6 autofill:pb-2"
                    placeholder="Name" />
                  <label for="hs-tac-input-name"
                    class="absolute top-0 start-0 p-4 h-full text-neutral-400 text-sm truncate pointer-events-none transition ease-in-out duration-100 border border-transparent peer-disabled:opacity-50 peer-disabled:pointer-events-none peer-focus:text-xs peer-focus:-translate-y-1.5 peer-focus:text-neutral-400 peer-[:not(:placeholder-shown)]:text-xs peer-[:not(:placeholder-shown)]:-translate-y-1.5 peer-[:not(:placeholder-shown)]:text-neutral-400">
                    Nimi
                  </label>
                </div>

                <!-- //LINK - E-post -->
                <div class="relative">
                  <input type="email" id="hs-tac-input-email" name="email"
                    class="peer p-4 block w-full bg-neutral-800 border-transparent rounded-lg text-sm text-white placeholder:text-transparent focus:outline-none focus:ring-0 focus:border-transparent disabled:opacity-50 disabled:pointer-events-none focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2 autofill:pt-6 autofill:pb-2"
                    placeholder="Email" />
                  <label for="hs-tac-input-email"
                    class="absolute top-0 start-0 p-4 h-full text-neutral-400 text-sm truncate pointer-events-none transition ease-in-out duration-100 border border-transparent peer-disabled:opacity-50 peer-disabled:pointer-events-none peer-focus:text-xs peer-focus:-translate-y-1.5 peer-focus:text-neutral-400 peer-[:not(:placeholder-shown)]:text-xs peer-[:not(:placeholder-shown)]:-translate-y-1.5 peer-[:not(:placeholder-shown)]:text-neutral-400">
                    E-post
                  </label>
                </div>

                <!-- //LINK - Tundsid -->
                <div class="relative">
                  <input type="text" id="hs-tac-input-company" name="connection"
                    class="peer p-4 block w-full bg-neutral-800 border-transparent rounded-lg text-sm text-white placeholder:text-transparent focus:outline-none focus:ring-0 focus:border-transparent disabled:opacity-50 disabled:pointer-events-none focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2 autofill:pt-6 autofill:pb-2"
                    placeholder="Company" />
                  <label for="hs-tac-input-company"
                    class="absolute top-0 start-0 p-4 h-full text-neutral-400 text-sm truncate pointer-events-none transition ease-in-out duration-100 border border-transparent peer-disabled:opacity-50 peer-disabled:pointer-events-none peer-focus:text-xs peer-focus:-translate-y-1.5 peer-focus:text-neutral-400 peer-[:not(:placeholder-shown)]:text-xs peer-[:not(:placeholder-shown)]:-translate-y-1.5 peer-[:not(:placeholder-shown)]:text-neutral-400">
                    Kuidas Sa Normanit tundsid?
                  </label>
                </div>

                <!-- //LINK - Mälestus -->
                <div class="relative">
                  <textarea id="hs-tac-message" name="memory"
                    class="peer p-4 block w-full bg-neutral-800 border-transparent rounded-lg text-sm text-white placeholder:text-transparent focus:outline-none focus:ring-0 focus:border-transparent disabled:opacity-50 disabled:pointer-events-none focus:pt-6 focus:pb-2 [&:not(:placeholder-shown)]:pt-6 [&:not(:placeholder-shown)]:pb-2 autofill:pt-6 autofill:pb-2 min-h-[200px] sm:min-h-[120px]"
                    placeholder="This is a textarea placeholder"></textarea>
                  <label for="hs-tac-message"
                    class="absolute top-0 start-0 p-4 h-full text-neutral-400 text-sm truncate pointer-events-none transition ease-in-out duration-100 border border-transparent peer-disabled:opacity-50 peer-disabled:pointer-events-none peer-focus:text-xs peer-focus:-translate-y-1.5 peer-focus:text-neutral-400 peer-[:not(:placeholder-shown)]:text-xs peer-[:not(:placeholder-shown)]:-translate-y-1.5 peer-[:not(:placeholder-shown)]:text-neutral-400">
                    Kirjuta siia oma meenutus või järelehüüe
                  </label>
                </div>

              </div>


              <!-- //LINK - Kohustuslikud väljad -->
              <div class="mt-2 text-center">
                <p class="text-xs text-neutral-500">Kõik väljad on kohustuslikud</p>
              </div>


              <!-- //LINK - Saada -->
              <div class="mt-4 text-center">
                <button type="submit"
                  class="group inline-flex items-center gap-x-2 py-3 px-6 bg-gray-100 text-gray-800 hover:bg-gray-50 font-medium text-lg rounded-full focus:outline-none focus:bg-gray-50">
                  Postita meenutus
                  <svg
                    class="flex-shrink-0 size-4 transition group-hover:translate-x-0 group-hover:translate-x-0 group-focus:translate-x-0 group-focus:translate-x-0"
                    xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect width="20" height="16" x="2" y="4" rx="2"></rect>
                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"></path>
                  </svg>
                </button>
              </div>
              <!-- //LINK - Meenutused -->

            </form>
            <!-- //!SECTION - Form -->

            <script>
              document.getElementById("memory-form").addEventListener("submit", function(e) {
                e.preventDefault(); // Peatab vormi tavapärase esituse

                const form = this;
                const formData = new FormData(form);

                fetch("/norman/upload.php", {
                    method: "POST",
                    body: formData,
                  })
                  .then((response) => response.json())
                  .then((data) => {
                    if (data.success) {
                      alert("Meenutus edukalt salvestatud!");
                      window.location.reload(); // Värskendab lehe pärast edukat postitust
                    } else {
                      alert("Viga: " + data.message);
                    }
                  })
                  .catch((error) => {
                    console.error("Viga:", error);
                    alert("Tekkis ootamatu viga. Palun proovige uuesti.");
                  });
              });
            </script>

          </div>
          <!-- End Col -->

        </div>
        <!-- End Grid -->

      </div>
    </div>
    <!-- End Contact -->
  </main>
  <!-- ========== END MAIN CONTENT ========== -->



  <!-- JS Implementing Plugins -->

  <!-- JS PLUGINS -->
  <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js"></script>
  <!-- Dropzone -->
  <script src="https://unpkg.com/dropzone@5/dist/min/dropzone.min.js"></script>
  <script>
    Dropzone.options.memoryForm = {
      paramName: "file", // Name of the parameter sent to PHP
      maxFilesize: 2, // Max filesize in MB
      acceptedFiles: "image/*", // Accept only images
      success: function(file, response) {
        console.log("Upload successful: ", response);
      },
      error: function(file, errorMessage) {
        console.error("Upload failed: ", errorMessage);
      }
    };
  </script>


  <!-- Required plugins -->
  <script src="https://cdn.jsdelivr.net/npm/preline/dist/preline.min.js"></script>

  <!-- JS INITIALIZATIONS -->
  <script>
    (function() {
      function textareaAutoHeight(el, offsetTop = 0) {
        el.style.height = 'auto';
        const minHeight = window.innerWidth >= 1024 ? '200px' : 'auto'; // Set minimum height for lg screens
        el.style.height = `${Math.max(el.scrollHeight + offsetTop, parseInt(minHeight))}px`;
      }

      (function() {
        const textareas = [
          '#hs-tac-message'
        ];

        textareas.forEach((el) => {
          const textarea = document.querySelector(el);
          const overlay = textarea.closest('.hs-overlay');

          if (overlay) {
            const {
              element
            } = HSOverlay.getInstance(overlay, true);

            element.on('open', () => textareaAutoHeight(textarea, 3));
          } else textareaAutoHeight(textarea, );

          textarea.addEventListener('input', () => {
            textareaAutoHeight(textarea, 3);
          });

          // Update height on window resize
          window.addEventListener('resize', () => {
            textareaAutoHeight(textarea, 3);
          });
        });
      })();
    })()
  </script>
  <script>
    const html = document.querySelector('html');
    html.classList.add('dark');
  </script>


</body>

</html>